#version 430 core
layout(vertices = 3) out;

layout (location = 0) in vec4 vPosition[];

layout (location = 0) out vec4 tessPosition[];


uniform int tesselationOn = 1;

void main(void)
{	 
	float tessPowerInner = 1.0;
	float tessPowerOuter = 1.0;

	if(tesselationOn == 1){
		tessPowerInner = 2.0;
		tessPowerOuter = 2.0;
	}else{
		tessPowerInner = 1.0;
		tessPowerOuter = 1.0;
	}

	tessPosition[gl_InvocationID] = vPosition[gl_InvocationID];

	gl_TessLevelInner[0] = tessPowerInner;
	gl_TessLevelInner[1] = tessPowerInner;

	gl_TessLevelOuter[0] = tessPowerOuter;
	gl_TessLevelOuter[1] = tessPowerOuter;
	gl_TessLevelOuter[2] = tessPowerOuter;
	gl_TessLevelOuter[3] = tessPowerOuter;
}